Ext.define('Photoalbum.view.DetailMap', {
	extend: 'Ext.Panel',
	xtype: 'photoalbum-detail-map',
	id: 'detailmap',
	initialized: false,

    config : {
    	title: 'Karte',
    	layout: 'fit',
    	items: [{
    		docked: 'bottom',
    		xtype: 'panel',
    		layout: 'hbox',
    		items: [{
    			xtype: 'textfield',
    			id: 'address',
    			flex: 12
    		}, {
    			xtype: 'button',
    			iconMask: true,
    			iconCls: 'locate',
    			id: 'locate',
    			flex: 1,
    		}]
    	},{
    		xtype: 'map',
    		mapOptions: {
    			center: new google.maps.LatLng(53.56, 13.253),
    			zoom: 7
    		}
    	}]	
    },
    
    bindMap: function(coords) {
    	if(typeof coords != 'undefined' && 'length' in coords && coords.length==3) {
    		var position = new google.maps.LatLng(coords[1],coords[2]);
    		var gmap = this.child('map').getMap();
    		this.addMarker(coords[0], gmap, position);
    		gmap.setCenter(position);
    		gmap.setZoom(14);
    		var geocoder = new google.maps.Geocoder();;
    		geocoder.geocode({'latLng': position}, function(results, status) {
    			if (status == google.maps.GeocoderStatus.OK) {
    				if (results[1]) {
    					Ext.getCmp('detailmap').down('#address').setValue(results[1].formatted_address);
    				}
    			}
    		});
    	}
    },
    
    addMarker: function(phid, map, position) {
    	if(this.markers.containsKey(phid)) {
    		var marker = this.markers.get(phid);
    		marker.setPosition(position);
    	} else {
	        var marker = new google.maps.Marker({
	            map: map,
	            position: position
	        });
	        this.markers.add(phid, marker);
	        var url = Ext.getCmp('table').getSelection()[0].picasa().getAt(0).get('url');
	        google.maps.event.addListener(marker, 'mousedown', function() {
	        	var infowindow = new google.maps.InfoWindow({
	        	    content: '<img src="'+url+'" width="50px">',
	        	    maxWidth: 50
	        	});
	        	infowindow.open(map,marker);
	        });
    	}            
    },
    
    markers: Ext.create('Ext.util.HashMap'),
    
    updateLocation: function(photo, address) {
    	var geocoder = new google.maps.Geocoder();
    	var phid = photo.get('id');
    	geocoder.geocode({'address': address}, function(results, status) {
    		if (status == google.maps.GeocoderStatus.OK) {
    			//Update UI
    			var lat = results[0].geometry.location.lat();
    			var lng = results[0].geometry.location.lng();
    			Ext.getCmp('detailmap').bindMap([phid,lat,lng]);
    			//Update Store
    			photo.locationupdate = ""+lat+" "+lng;
    		}
    	});
    }
    
});